import numpy as np

def main(input_grid):
    # Find the element with the least amount of occurrences in the input grid
    unique_elements, counts = np.unique(input_grid, return_counts=True)
    least_element = unique_elements[np.argmin(counts)]
    
    # Collect the positions of the least amount element
    least_positions = np.argwhere(input_grid == least_element)
    
    # Find the max and min position in the least positions
    max_pos = np.max(least_positions, axis=0)
    min_pos = np.min(least_positions, axis=0)
    
    # Collect the blocks from the input grid according to the max-min position
    block = input_grid[min_pos[0]:max_pos[0]+1, min_pos[1]:max_pos[1]+1]
    
    # Output the entire block generated
    return block