import numpy as np
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)
def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the upper left and lower right corners of non-blue pixels
    non_blue_pixels = np.where(input_grid != blue)
    upper_left = (np.min(non_blue_pixels[0]), np.min(non_blue_pixels[1]))
    lower_right = (np.max(non_blue_pixels[0]), np.max(non_blue_pixels[1]))
    # Create the output grid
    output_grid = np.zeros((lower_right[0]-upper_left[0]+1, lower_right[1]-upper_left[1]+1), dtype=int)
    # Copy the non-blue pixels from the input grid to the output grid
    for i in range(upper_left[0], lower_right[0]+1):
        for j in range(upper_left[1], lower_right[1]+1):
            if input_grid[i][j] != blue:
                output_grid[i-upper_left[0]][j-upper_left[1]] = input_grid[i][j]
    return output_grid
