import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the dimensions of the input grid
    rows, cols = input_grid.shape
    
    # Create an empty output grid with the same dimensions as the input grid
    output_grid = np.zeros((rows, cols), dtype=int)
    
    # Rotate the input grid 180 degrees clockwise
    for i in range(rows):
        for j in range(cols):
            output_grid[i][j] = input_grid[rows-i-1][cols-j-1]
    
    return output_grid