using Statistics, StatsPlots, ColorSchemes;


pal_colors = palette(:tab20);
dict_colors = Dict("TTUCB" => pal_colors[7],
                   "EB-TCI" => pal_colors[1],
                   "T3C" => pal_colors[19],
                   "LUCB" => pal_colors[16],
                   "1/2-LUCB" => pal_colors[17],
                   "Uniform" => pal_colors[14]);

Ks = [10, 50, 100, 250, 500, 750, 1000];


# Sparse Benchmark

μs_EB = [2853, 15030, 30487, 80219, 163337, 251249, 332075];
σs_EB = [833, 2445, 4128, 8229, 17914, 22922, 32279];
μs_UCB = [2740, 14676, 31916, 83523, 177977, 288852, 388713];
σs_UCB = [1087, 4262, 8421, 19172, 40173, 63466, 86323];
μs_TS = [2481, 10205, 19783, 49159, 94571, 143646, 191378];
σs_TS = [1387, 2401, 2833, 17257, 6850, 11652, 14919];
μs_LUCB = [8827, 16548, 29931, 70702, 138592, 204960, 276745];
σs_LUCB = [4747, 2979, 3208, 6426, 12091, 18104, 23497];
μs_LUCBs = [4244, 16190, 30238, 73017, 140917, 216554, 275199];
σs_LUCBs = [1082, 2206, 3800, 8798, 10288, 83298, 21985];
μs_Unif = [4766, 34261, 73623, 205505, 445117, 655090, 912362];
σs_Unif = [1966, 11058, 25959, 64700, 126746, 192738, 262137];

plot(Ks, μs_EB, ribbon=σs_EB, fillalpha=.3, label="EB-TCI", color=dict_colors["EB-TCI"], markershape=:auto, linestyle=:auto, legend=:topleft, xaxis=:log, yaxis=:log, xlabel="number of arms K");
plot!(Ks, μs_UCB, ribbon=σs_UCB, fillalpha=.3, label="TTUCB", color=dict_colors["TTUCB"], markershape=:auto, linestyle=:auto);
plot!(Ks, μs_TS, ribbon=σs_TS, fillalpha=.3, label="T3C", color=dict_colors["T3C"], markershape=:auto, linestyle=:auto);
plot!(Ks, μs_LUCB, ribbon=σs_LUCB, fillalpha=.3, label="LUCB", color=dict_colors["LUCB"], markershape=:auto, linestyle=:auto);
plot!(Ks, μs_LUCBs, ribbon=σs_LUCBs, fillalpha=.3, label="1/2-LUCB", color=dict_colors["1/2-LUCB"], markershape=:auto, linestyle=:auto);
plot!(Ks, μs_Unif, ribbon=σs_Unif, fillalpha=.3, label="Uniform", color=dict_colors["Uniform"], markershape=:auto, linestyle=:auto);
file = "sparse_benchmark_N100_delta1.pdf"
savefig(file);


# Alpha 0.3 Benchmark

μs_EB = [326, 2242, 4791, 13272, 29285, 45561, 63289];
σs_EB = [127, 380, 793, 1719, 3556, 4955, 6364];
μs_UCB = [328, 2327, 5758, 17587, 44156, 66564, 99586];
σs_UCB = [137, 786, 1847, 4541, 9794, 16379, 20828];
μs_TS = [288, 1497, 2921, 7379, 14732, 22768, 30151];
σs_TS = [113, 330, 578, 1167, 1851, 2405, 2984];
μs_LUCB = [503, 2309, 4549, 11051, 22118, 33108, 43884];
σs_LUCB = [138, 383, 610, 1117, 1682, 1984, 2604];
μs_LUCBs = [513, 2353, 4550, 11116, 21883, 32931, 44168];
σs_LUCBs = [144, 394, 663, 1210, 1847, 2783, 2913];
μs_Unif = [753, 10885, 31258, 140979, 451302, 876302, 1248462];
σs_Unif = [345, 5198, 15770, 73141, 239968, 491970, 637178];

plot(Ks, μs_EB, ribbon=σs_EB, fillalpha=.3, label="EB-TCI", color=dict_colors["EB-TCI"], markershape=:auto, linestyle=:auto, legend=:topleft, xaxis=:log, yaxis=:log, xlabel="number of arms K");
plot!(Ks, μs_UCB, ribbon=σs_UCB, fillalpha=.3, label="TTUCB", color=dict_colors["TTUCB"], markershape=:auto, linestyle=:auto);
plot!(Ks, μs_TS, ribbon=σs_TS, fillalpha=.3, label="T3C", color=dict_colors["T3C"], markershape=:auto, linestyle=:auto);
plot!(Ks, μs_LUCB, ribbon=σs_LUCB, fillalpha=.3, label="LUCB", color=dict_colors["LUCB"], markershape=:auto, linestyle=:auto);
plot!(Ks, μs_LUCBs, ribbon=σs_LUCBs, fillalpha=.3, label="1/2-LUCB", color=dict_colors["1/2-LUCB"], markershape=:auto, linestyle=:auto);
plot!(Ks, μs_Unif, ribbon=σs_Unif, fillalpha=.3, label="Uniform", color=dict_colors["Uniform"], markershape=:auto, linestyle=:auto);
file = "alpha3_benchmark_N100_delta1.pdf"
savefig(file);

# Alpha 0.6 Benchmark

Ks = [10, 50, 100, 250, 500];

μs_EB = [846, 7848, 20942, 72914, 188204];
σs_EB = [412, 2508, 6876, 20950, 48453];
μs_UCB = [918, 9840, 28948, 112118, 306619];
σs_UCB = [488, 4269, 10627, 35383, 86666];
μs_TS = [743, 6402, 15124, 50239, 122534];
σs_TS = [396, 2450, 6278, 18480, 44700];
μs_LUCB = [1330, 10538, 27225, 79116, 199604];
σs_LUCB = [501, 3736, 11903, 26884, 87390];
μs_LUCBs = [1433, 11168, 26635, 83200, 203261];
σs_LUCBs = [604, 3872, 9515, 25802, 50972];
μs_Unif = [2669, 97891, 474390, 3728244, 16636042];
σs_Unif = [1521, 55557, 286561, 2379211, 11053993];

plot(Ks, μs_EB, ribbon=σs_EB, fillalpha=.3, label="EB-TCI", color=dict_colors["EB-TCI"], markershape=:auto, linestyle=:auto, legend=:topleft, xaxis=:log, yaxis=:log, xlabel="number of arms K");
plot!(Ks, μs_UCB, ribbon=σs_UCB, fillalpha=.3, label="TTUCB", color=dict_colors["TTUCB"], markershape=:auto, linestyle=:auto);
plot!(Ks, μs_TS, ribbon=σs_TS, fillalpha=.3, label="T3C", color=dict_colors["T3C"], markershape=:auto, linestyle=:auto);
plot!(Ks, μs_LUCB, ribbon=σs_LUCB, fillalpha=.3, label="LUCB", color=dict_colors["LUCB"], markershape=:auto, linestyle=:auto);
plot!(Ks, μs_LUCBs, ribbon=σs_LUCBs, fillalpha=.3, label="1/2-LUCB", color=dict_colors["1/2-LUCB"], markershape=:auto, linestyle=:auto);
plot!(Ks, μs_Unif, ribbon=σs_Unif, fillalpha=.3, label="Uniform", color=dict_colors["Uniform"], markershape=:auto, linestyle=:auto);
file = "alpha6_benchmark_N100_delta1.pdf"
savefig(file);

