
import numpy as np
import gurobipy as gp
from gurobipy import GRB
import itertools
import json
import random
import copy

def eliminate_cycle(  unr, edge,  rev, F, NofA, NofR, submission, choice, bandr,kp,ka, order):



    cycle=[unr[0]]
    current=unr[0]
    while(True):
        current=edge[current]
        if (current in cycle):
            break
        else:
            cycle.append(current)
    index = cycle.index(current)
    cycle=cycle[index :]

    if rev:
        cycle.reverse()
    for r in range(len(cycle)):
        if r==len(cycle)-1:
            l=0
        else:
            l=r+1
        if cycle[r] in unr:


            F[cycle[l], choice[cycle[r]]]=1
            NofA[choice[cycle[r]]]+=1
            if NofA[choice[cycle[r]]]==kp:
                submission[cycle[r]].remove(choice[cycle[r]])
                if not submission[cycle[r]]:
                    unr.remove(cycle[r])
                    order.append(cycle[r])
                    if NofR[cycle[r]]<ka:
                        bandr.append(cycle[r])
            NofR[cycle[l]]+=1


            if NofR[cycle[l]]==ka and cycle[l] in bandr:
                bandr.remove(cycle[l])

    return F, NofA, NofR,  submission, unr, bandr,order

def eliminate_cycle_filling_gaps(  unr, edge,  rev, F, NofA, NofR, submission, choice, bandr,kp,ka, order):
#    print("Edges", edge)
    cycle=[unr[0]]
    current=unr[0]
    while(True):
        current=edge[current]
        if (current in cycle):
            break
        else:
            cycle.append(current)
    index = cycle.index(current)
    cycle=cycle[index :]

    if rev:
        cycle.reverse()
    for r in range(len(cycle)):
        if r==len(cycle)-1:
            l=0
        else:
            l=r+1
        if cycle[r] in unr:

            F[cycle[l], int(choice[cycle[r],cycle[l]])]=1
            NofA[choice[cycle[r],cycle[l]]]+=1
            if NofA[choice[cycle[r],cycle[l]]]==kp:
                submission[cycle[r]].remove(choice[cycle[r],cycle[l]])
                if not submission[cycle[r]]:
                    unr.remove(cycle[r])
                    order.append(cycle[r])
                    if NofR[cycle[r]]<ka:
                        bandr.append(cycle[r])
            NofR[cycle[l]]+=1


            if NofR[cycle[l]]==ka and cycle[l] in bandr:
                bandr.remove(cycle[l])

    return F, NofA, NofR,  submission, unr, bandr,order


def PeerReview_TTC(S, R, P,  kp, ka,submission):
    NofA={}
    for p in P:
        NofA[p]=0
    NofR={}
    for r in R:
        NofR[r]=0

    F = np.zeros_like(S)
    unr=list(R)
    bandr=[]
    order=[]
    desc_list_of_reviewers= np.zeros((len(R),len(P),len(R)))
    for r in R:
        for p in submission[r]:
            desc_list_of_reviewers[r][p][:]=np.flip(np.argsort(S[:,p]))

    while(True):
        if not unr:
            break
        else:
            outgoing={}
            choice={}
            for r in bandr:
                outgoing[r]=unr[0]
            for r in unr:
                outgoing[r]=-1
                choice[r]=submission[r][0]
            for r in unr:
                for r1 in range(len(R)):
                    reviewer=int(desc_list_of_reviewers[r][choice[r]][r1])
                    if r!=reviewer and (reviewer in unr+bandr) and (F[reviewer,choice[r]]==0):
                        outgoing[r]=reviewer
                        break
            if -1 in outgoing.values():##This means that |unr|<kp+1
                break

            F, NofA, NofR,  submission, unr, bandr,order=eliminate_cycle(unr,outgoing,0,F, NofA, NofR,submission, choice,  bandr,kp,ka,order)

    return F,unr,order,NofA, NofR,submission,bandr
        ###########################

def filling_gaps(S,R,P,kp,ka,F,unr, last,NofA, NofR, submission,initial_sumbission,bandr,nrev):
    print("filling_gaps")
    last1=list(last)
    U=list(unr)

    order=[]
    while( len(unr)>0):
        candidate=np.zeros([S.shape[0]])
        candidate+=-1
        ingoing={}
        choice=np.zeros((nrev,nrev))
        for r1 in unr:
            candidate[r1]=1
            for r2 in unr:
                if candidate[r1]==1:
                    if r1!=r2:
                        for p in submission[r2]:

                            if  F[r1,p]==0:
                                candidate[r1]=0
                                ingoing[r1]=r2
                                choice[r2,r1]=p

                                break

                else:
                    break



        if 1 in candidate:
            index=np.where(candidate==1)
            index=index[0]
            order.extend(index)
            unr=list(set(unr).difference(set(index)))
        else:
            F, NofA, NofR, submission, unr, bandr,last1=eliminate_cycle_filling_gaps(unr, ingoing, 1,   F, NofA,  NofR, submission, choice, bandr, kp, ka,last1)

    L=last[len(last)-(kp-len(U)+1):]
    for r in order:
        if not submission[r]:
            continue
        else:
            for p in submission[r]:
                while(NofA[p]<kp):
                    find=0
                    ran=list(set(L+U)-set([r]))
                    paper=[]
                    for r1 in ran:
                    #    if find==0:
                        for p1 in initial_sumbission[r1]:
                            if  F[r,p1]==0 and NofA[p1]==kp:
                                paper.append(p1)
                                #find=1
                                #break
                        # else:
                        #     break
                    current_score=1
                    for cp in paper:
                        reviewers=np.where(F[:,cp]==1)
                        reviewers=reviewers[0]

                        for r1 in reviewers:
                            if F[r1,p]==0:
                                if S[r1,cp]<= current_score:
                                    paper_ex=cp
                                    reviewer_ex=r1
                                    current_score=S[r1,cp]
                    F[r1,p]=1
                    F[r1,cp]=0
                    F[r,cp]=1
                    NofA[p]+=1
                    NofR[r]+=1
                                #break

    return F


def core(S,A,kp,ka):
    nrev, npap = A.shape
    R=list(range(nrev))
    P=list(range(npap))
    ####Initilization######
    initial_submission={}
    for r in R:
        initial_submission[r]=[]

    for r in R:
        for  p in P:
            if A[r,p]==1:
                initial_submission[r].append(p)



    maxList=1
    for r in R:
        if len(initial_submission[r])==2:

            maxList=2
            break

    if maxList==2:
        for r in R:
            if len(initial_submission[r])==1:

                new_column=np.zeros((nrev,1))
                new_column[r,0]=1
                A=np.append(A, new_column,axis=1)

                new_column=np.zeros((nrev,1))
                S=np.append(S, new_column,axis=1)

    nrev, npap = A.shape
    R=list(range(nrev))
    P=list(range(npap))
    initial_submission={}
    for r in R:
        initial_submission[r]=[]

    for r in R:
        for  p in P:
            if A[r,p]==1:
                initial_submission[r].append(p)


    submission=copy.deepcopy(initial_submission)
    F,unr,order, NofA, NofR, submission,bandr=PeerReview_TTC(S,R,P,kp,ka,submission)

    if unr:
        F=filling_gaps(S,R,P, kp,ka,F,unr, order, NofA, NofR, submission, initial_submission,bandr,nrev)

    return F
