import os
import re
import pickle
import numpy as np
import matplotlib.pyplot as plt

from matplotlib.pyplot import figure

output_dir = "results/states"
num_states = [10, 20, 50, 100, 500, 1000]
vanilla_err_pattern = r'.*vanilla_errors\.csv$'
vanilla_indices_pattern = r'.*vanilla_indices\.csv$'
figure(figsize=(20, 12), dpi=100)

# Plot experiement results
plt.figure(1)
for q in num_states:
    path = output_dir + str(q)
    files = os.listdir(path)
    error_file = [file for file in files if re.match(vanilla_err_pattern, file)][0]
    indices_file = [file for file in files if re.match(vanilla_indices_pattern, file)][0]
    print("Error File : ", error_file)
    print("Indices File : ", indices_file)
    with open(path+"/"+error_file, 'rb') as fp:
        errors = np.array(pickle.load(fp))
    with open(path+"/"+indices_file, 'rb') as fp:
        indices = np.array(pickle.load(fp))
    print(", Number of indices : ", len(indices), ". Number of error values : ", len(errors))
    plt.plot(indices, errors, label = "States = "+str(q))

plt.title("Sine-squared error vs Number of Samples")
plt.xlabel("Num Samples")
plt.ylabel("Sine-squared error")
plt.legend()
plt.show()
