## List of files

- The `mathematica` folder contains the mathematica notebooks that were used to obtain the expressions as mentioned in the appendix.

- The `LQR_Experiment` folder contains the code for LQR experiments
    

    - data/: a directory containing all the data files

    python scripts:

    - LQR_Scalar.py: the script that generates the files in `data` directory for `n=1`, finite horizon.
                     See docstring in the script for an example
    - plot_scalar.py: plot from data generated by LQR_Scalar.py to produce Fig. 1(a)(b) and Fig. 5(a)-(d)

    jupyter notebooks (require jupyter notebook to be installed; run `$ jupyter notebook` in terminal to start):

    - LQR_Vector_Experiments_finite_hor_random.ipynb: MSE for n=3, finite horizon, random A, Fig. 1(c)
    - LQR_Vector_Experiments_infinite_horizon_random.ipynb: MSE for n=3, infinite horizon, random A, in Fig. 1(d)
    - LQR_Vector_finite_horizon.ipynb: MSE for n=3, finite horizon, in Fig. 4(a)
    - LQR_Vector_infinite_horizon.ipynb: MSE for n=3, infinite horizon, in Fig. 4(b)

- The `nonlinear` folder contains the code for nonlinear experiments