"""
Constants for environments. Many of these are taken from
https://github.com/twni2016/pomdp-baselines/blob/main/scripts/constants.py
"""


TABLE_RESULTS = {
    "AntBLT-P-v0": {
        "return": {"Oracle": 3394, "Markovian": 1132.946, "Random": 372.6779},
    },
    "AntBLT-V-v0": {
        "return": {"Oracle": 3394, "Markovian": 645.05, "Random": 372.6779},
    },
    "HalfCheetahBLT-P-v0": {
        "return": {"Oracle": 2994, "Markovian": 870.48, "Random": -1256.6604},
    },
    "HalfCheetahBLT-V-v0": {
        "return": {"Oracle": 2994, "Markovian": 517.946, "Random": -1256.6604},
    },
    "HopperBLT-P-v0": {
        "return": {"Oracle": 2434, "Markovian": 477.911, "Random": 19.9634},
    },
    "HopperBLT-V-v0": {
        "return": {"Oracle": 2434, "Markovian": 228.366, "Random": 19.9634},
    },
    "WalkerBLT-P-v0": {
        "return": {"Oracle": 2225, "Markovian": 471.815, "Random": 16.5319},
    },
    "WalkerBLT-V-v0": {
        "return": {"Oracle": 2225, "Markovian": 214.45, "Random": 16.5319},
    },
}

PID_RESULTS = {
    'msd-fixed': {
        'fixed': (-6.142046948660148, 0.018082849854935273),
        'small': (-7.505402229856199, 0.04051139045255491),
        'large': (-11.392079950974423, 0.08784477244402583),
    },
    'msd-small': {
        'fixed': (-6.264284817394474, 0.06410486218115197),
        'small': (-7.491470115234788, 0.0260505350784092),
        'large': (-11.178897270373117, 0.08673868791633159),
    },
    'msd-large': {
        'fixed': (-6.775032259473903, 0.16479710887193924),
        'small': (-7.780804426708936, 0.11913288938376605),
        'large': (-11.115020478576497, 0.05255847630088044),
    },
    'dmsd-fixed': {
        'fixed': (-15.333865440123734, 0.14120811105854714),
        'small': (-21.291801803949998, 0.2896852968744336),
        'large': (-27.59013773978082, 0.4397334809075726),
    },
    'dmsd-small': {
        'fixed': (-18.154094169738038, 0.9060264117679807),
        'small': (-21.778215664772016, 0.1360043112615893),
        'large': (-26.5672720274572, 0.2179967268451881),
    },
    'dmsd-large': {
        'fixed': (-21.961142339410255, 0.6201016463221901),
        'small': (-22.299553077703365, 0.4387819414011955),
        'large': (-25.294536870477884, 0.2972469473676861),
    },
    'nav-sim': {
        'sim': (-17.23202575293877, 0.18257069829468944),
        'real': (-23.869991167863006, 0.28884173573602423),
    },
    'nav-real': {
        'sim': (-18.68882885495155, 0.20575702382008826),
        'real': (-20.51959452059961, 0.28427870179074294),
    },
    'fusion-sim': {
        'sim': (-8.09, 0.00486),
        'real': (-16.411, 0.305),
    },
    'fusion-real': {
        # 'sim': (-13.614416116704295, 0.25614090854554183),
        # 'real': (-12.76401607708504, 0.18288343346182595),
        'sim': (-12.122, 0.396),
        'real': (-13.559, 0.235),
    },
    'bnrot-sim': {
        'sim': (-27.56, 0.076),
        'real': (-30.08, 0.95),
    },
    'bnrot-real': {
        'sim': (-35.57, 1.505),
        'real': (-27.09, 0.304),
    },
}

NO_ACTION_RESULTS = {
    'msd': {
        'fixed': (-78.97, 4.44),
        'small': (-80.43, 4.19),
        'large': (-79.98, 4.32),
    },
    'dmsd': {
        'fixed': (-154.47, 5.75),
        'small': (-143.45, 5.12),
        'large': (-153.18, 5.42),
    },
    'nav': {
        'sim': (-67.01, 1.34),
        'real': (-68.43, 1.37),
    },
    'fusion': {
        'sim': (-54.25, 1.79),
        'real': (-61.03, 3.38),
    },
}
