import random
import numpy as np


def gen_input(max_t=10, max_n=10):
    max_t = min(max_t, 10 ** 6)
    max_n = min(max_n, int((10 ** 6) ** 0.5))
    t = random.randint(1, max_t)
    result = [str(t)]
    for _ in range(t):
        n = random.randint(1, max_n)
        m = random.randint(1, max(min(max_n, int(10 ** 6 / n)), 1))
        result.append(f'{n} {m}')
        grid = np.random.choice(['.', '#'], size=(n, m), p=[0.7, 0.3])
        (lab_x, lab_y) = (random.randint(0, n - 1), random.randint(0, m - 1))
        grid[lab_x, lab_y] = 'L'
        for row in grid:
            result.append(''.join(row))
    return '\n'.join(result)

def batch_gen_inputs(batch_size,):
    inputs = []
    for _ in range(batch_size):
        inputs.append(gen_input(max_t=10, max_n=10))
    return inputs
