# TEST_RESULT: True


def solution(stdin: str) -> str:
    from collections import deque
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    tests = []
    line_idx = 1
    for _ in range(t):
        (n, m) = map(int, lines[line_idx].split())
        line_idx += 1
        grid = [list(lines[line_idx + i]) for i in range(n)]
        line_idx += n
        tests.append((n, m, grid))

    def in_grid_and_free(x, y, grid):
        return 0 <= x < len(grid) and 0 <= y < len(grid[0]) and (grid[x][y] != '#')

    def neighbors(x, y):
        return [(x + 1, y), (x, y + 1), (x - 1, y), (x, y - 1)]

    def can_reach_lab(x, y, lab_x, lab_y, grid):
        queue = deque([(x, y)])
        visited = set((x, y))
        while queue:
            (x, y) = queue.popleft()
            if (x, y) == (lab_x, lab_y):
                return True
            for (nx, ny) in neighbors(x, y):
                if in_grid_and_free(nx, ny, grid) and (nx, ny) not in visited:
                    queue.append((nx, ny))
                    visited.add((nx, ny))
        return False
    outputs = []
    for (n, m, grid) in tests:
        (lab_x, lab_y) = (None, None)
        for i in range(n):
            for j in range(m):
                if grid[i][j] == 'L':
                    (lab_x, lab_y) = (i, j)
                    break
            if lab_x is not None:
                break
        for i in range(n):
            for j in range(m):
                if grid[i][j] == '.' and can_reach_lab(i, j, lab_x, lab_y, grid):
                    grid[i][j] = '+'
        outputs.append('\n'.join((''.join(row) for row in grid)))
    return '\n'.join(outputs)
