# TEST_RESULT: True
from itertools import combinations
from typing import List

def longest_increasing_subsequence_length(arr: List[int]) -> int:
    dp = [1] * len(arr)
    for i in range(1, len(arr)):
        for j in range(0, i):
            if arr[i] > arr[j] and dp[i] < dp[j] + 1:
                dp[i] = dp[j] + 1
    maximum = 0
    for i in range(len(dp)):
        maximum = max(maximum, dp[i])
    return maximum

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    output = []
    for i in range(t):
        n = int(lines[i * 2 + 1])
        a = list(map(int, lines[i * 2 + 2].split()))
        for k in range(1, n + 1):
            for split in combinations(range(1, n), k - 1):
                split = (0,) + split + (n,)
                subarrays = [a[split[j]:split[j + 1]] for j in range(k)]
                lis_lengths = [longest_increasing_subsequence_length(subarray) for subarray in subarrays]
                xor = 0
                for lis_length in lis_lengths:
                    xor ^= lis_length
                if xor == 0:
                    output.append('YES')
                    break
            else:
                continue
            break
        else:
            output.append('NO')
    return '\n'.join(output)
