import random


def gen_input(num_people: int, num_friendships: int) -> str:
    N = random.randint(5, num_people)
    M = random.randint(0, min(num_friendships, N * (N - 1) // 2))
    friendships = set()
    while len(friendships) < M:
        U_i = random.randint(1, N)
        V_i = random.randint(1, N)
        if U_i != V_i:
            pair = tuple(sorted((U_i, V_i)))
            friendships.add(pair)
    input_str = f'{N} {M}\n'
    for pair in friendships:
        input_str += f'{pair[0]} {pair[1]}\n'
    return input_str

def batch_gen_inputs(batch_size,) -> list:
    inputs = [gen_input(10, 15) for _ in range(batch_size)]
    return inputs
