import random


def gen_input(max_tests: int, max_days: int) -> str:
    t = random.randint(1, max_tests)
    tests = []
    for _ in range(t):
        n = random.randint(1, max_days)
        days = [random.choice([0, 1]) for _ in range(n)]
        tests.append(f"{n}\n{' '.join(map(str, days))}")
    return f'{t}\n' + '\n'.join(tests)

def batch_gen_inputs(batch_size,) -> list:
    return [gen_input(5, 10) for _ in range(batch_size)]
