import random


def gen_input(max_size: int) -> str:
    max_size = max(3, min(max_size, 100))
    num_tests = random.randint(1, 10)
    input_string = str(num_tests) + '\n'
    for _ in range(num_tests):
        array_size = random.randint(3, max_size)
        array = random.sample(range(1, 201), array_size)
        input_string += str(array_size) + '\n' + ' '.join(map(str, array)) + '\n'
    return input_string

def batch_gen_inputs(batch_size,) -> list:
    inputs = [gen_input(5) for _ in range(batch_size)]
    return inputs
