import random


def gen_input(n, q):
    a = [random.randint(-10 ** 9, 10 ** 9) for _ in range(n)]
    tunnels = [(i + 1, random.randint(1, i)) for i in range(1, n)]
    queries = []
    for _ in range(q):
        query_type = random.randint(1, 2)
        if query_type == 1:
            u = random.randint(1, n)
            c = random.randint(-10 ** 9, 10 ** 9)
            queries.append((query_type, u, c))
        else:
            u = random.randint(1, n)
            v = random.randint(1, n)
            queries.append((query_type, u, v))
    input_str = f'{n} {q}\n'
    input_str += ' '.join(map(str, a)) + '\n'
    for (s, t) in tunnels:
        input_str += f'{s} {t}\n'
    for query in queries:
        input_str += ' '.join(map(str, query)) + '\n'
    return input_str

def batch_gen_inputs(batch_size,):
    return [gen_input(random.randint(2, 10), random.randint(1, 10)) for _ in range(batch_size)]
