import random


def gen_input(n_limit: int, k_limit: int) -> str:
    k_limit = min(n_limit, k_limit)
    n = random.randint(1, n_limit)
    k = random.randint(1, k_limit)
    positions = [(random.randint(-10 ** 5, 10 ** 5), random.randint(-10 ** 5, 10 ** 5)) for _ in range(n)]
    input_str = f'{n} {k}\n'
    input_str += '\n'.join((f'{x} {y}' for (x, y) in positions))
    return input_str

def batch_gen_inputs(batch_size,) -> list:
    input_batch = [gen_input(8, 4) for _ in range(batch_size)]
    return input_batch
