# TEST_RESULT: True
from typing import List, Tuple


def in_order_string(u: int, tree: List[Tuple[int, int]], labels: List[str]) -> str:
    if u == 0:
        return ''
    (left, right) = tree[u - 1]
    return in_order_string(left, tree, labels) + labels[u - 1] + in_order_string(right, tree, labels)

def generate_subsets(arr: List[int], k: int, index: int, current: List[int], subsets: List[List[int]]):
    if len(current) <= k:
        subsets.append(current.copy())
    for i in range(index, len(arr)):
        current.append(arr[i])
        generate_subsets(arr, k, i + 1, current, subsets)
        current.pop()

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    (n, k) = map(int, lines[0].split())
    labels = list(lines[1])
    tree = [tuple(map(int, line.split())) for line in lines[2:]]
    node_indices = list(range(1, n + 1))
    subsets = []
    generate_subsets(node_indices, k, 0, [], subsets)
    min_str_repr = None
    for subset in subsets:
        duplicated_labels = labels.copy()
        for i in subset:
            duplicated_labels[i - 1] *= 2
        str_repr = in_order_string(1, tree, duplicated_labels)
        if min_str_repr is None or str_repr < min_str_repr:
            min_str_repr = str_repr
    return min_str_repr
