import random


def gen_input(n: int) -> str:
    test_cases = random.randint(1, min(n, 10))
    input_str = str(test_cases) + '\n'
    for _ in range(test_cases):
        size = random.randint(1, min(n, 1000))
        input_str += str(size) + '\n'
        ranges = [[1, size]]
        for _ in range(size - 1):
            idx = random.randint(0, len(ranges) - 1)
            (l, r) = ranges.pop(idx)
            if l == r:
                d = l
            else:
                d = random.randint(l, r)
            if l <= d - 1:
                ranges.append([l, d - 1])
            if d + 1 <= r:
                ranges.append([d + 1, r])
        random.shuffle(ranges)
        for (l, r) in ranges:
            input_str += f'{l} {r}\n'
    return input_str

def batch_gen_inputs(batch_size,) -> list:
    inputs = []
    for _ in range(batch_size):
        inputs.append(gen_input(5))
    return inputs
