
import random
import numpy as np

def gen_input(t: int, n: int, m: int) -> str:
    assert 1 <= t <= 10 ** 4, 't is out of range'
    assert 1 <= n <= 10, 'n is out of range'
    assert 1 <= m <= 10 ** 4, 'm is out of range'
    input_str = str(t) + '\n'
    for _ in range(t):
        input_str += str(n) + ' ' + str(m) + '\n'
        max_score = m * (m + 1) // 2
        scores = [str(random.randint(0, max_score)) for _ in range(n)]
        input_str += ' '.join(scores) + '\n'
        for _ in range(n):
            answers = ''.join([str(random.randint(0, 1)) for _ in range(m)])
            input_str += answers + '\n'
    return input_str

def batch_gen_inputs(batch_size,) -> list:
    batch = []
    for _ in range(batch_size):
        t = random.randint(1, 10)
        n = random.randint(1, 10)
        m = random.randint(1, 10)
        batch.append(gen_input(t, n, m))
    return batch
