import random


def gen_input(t_max: int, n_max: int) -> str:
    t = random.randint(1, t_max)
    test_cases = []
    for _ in range(t):
        n = random.randint(1, n_max)
        permutation = random.sample(range(1, n + 1), n)
        test_cases.append((n, permutation))
    input_str = f'{t}\n'
    for (n, permutation) in test_cases:
        input_str += f'{n}\n'
        input_str += ' '.join((str(x) for x in permutation)) + '\n'
    return input_str

def batch_gen_inputs(batch_size,) -> list:
    inputs = []
    for _ in range(batch_size):
        inputs.append(gen_input(3, 6))
    return inputs
