# TEST_RESULT: True
from collections import deque


def operation(x, append):
    binary = bin(x)[2:] + str(append)
    binary_reversed = binary[::-1]
    return int(binary_reversed, 2)

def solution(stdin: str) -> str:
    (x, y) = map(int, stdin.strip().split())
    visited = set()
    queue = deque([x])
    while queue:
        current = queue.popleft()
        if current == y:
            return 'YES'
        if current not in visited:
            visited.add(current)
            for append in [0, 1]:
                next_num = operation(current, append)
                if next_num <= y and next_num not in visited:
                    queue.append(next_num)
    return 'NO'
