import random

def gen_input(num_cases: int, max_elements: int) -> str:
    assert 1 <= num_cases <= 1000, 'Number of test cases is out of constraints'
    assert 2 <= max_elements <= 100, 'Number of elements in array is out of constraints'
    cases = []
    for _ in range(num_cases):
        num_elements = random.randint(2, max_elements)
        array = ' '.join((str(random.randint(1, 10 ** 18)) for _ in range(num_elements)))
        case = f'{num_elements}\n{array}'
        cases.append(case)
    input_str = f'{num_cases}\n' + '\n'.join(cases)
    return input_str

def batch_gen_inputs(batch_size,) -> list:
    inputs = []
    for _ in range(batch_size):
        num_cases = random.randint(1, 5)
        max_elements = random.randint(2, 10)
        inputs.append(gen_input(num_cases, max_elements))
    return inputs
