import random


def gen_input(test_cases: int, max_length: int) -> str:
    input_str = str(test_cases) + '\n'
    lego_states = ['0', '1', '?']
    for _ in range(test_cases):
        n = random.randint(2, max_length)
        start_state = ''.join((random.choice(lego_states) for _ in range(n)))
        end_state = ''.join((random.choice(lego_states) for _ in range(n)))
        input_str += str(n) + '\n' + start_state + '\n' + end_state + '\n'
    return input_str

def batch_gen_inputs(batch_size,) -> list:
    inputs = []
    test_cases_list = [1, 2, 3, 4, 5, 6, 7, 8, 9]
    for _ in range(batch_size):
        test_cases = random.choice(test_cases_list)
        for max_length in range(2, 7):
            inputs.append(gen_input(test_cases, max_length))
    return inputs
