# TEST_RESULT: True

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    offset = 1
    out = []
    for _ in range(t):
        while offset < len(lines) and lines[offset] == '':
            offset += 1
        (n, m) = map(int, lines[offset].split())
        offset += 1
        dishes = []
        for _ in range(n):
            (fish, meat) = map(int, lines[offset].split())
            offset += 1
            dishes.append((fish, meat))
        combinations = [(i, m - i) for i in range(m + 1)]
        min_balance = float('inf')
        best_combination = None
        for combination in combinations:
            total_fish = total_meat = 0
            for (fish, meat) in dishes:
                fish_eaten = min(fish, combination[0])
                meat_eaten = min(meat, combination[1])
                total_fish += fish_eaten
                total_meat += meat_eaten
            balance = abs(total_fish - total_meat)
            if balance < min_balance:
                min_balance = balance
                best_combination = combination
        out.append(str(min_balance))
        for _ in range(n):
            out.append(f'{best_combination[0]} {best_combination[1]}')
    return '\n'.join(out)

if __name__ == '__main__':
    inputs = ['3\n\n1 10\n15 7\n\n3 1\n0 4\n12 8\n12 3\n\n1 5\n7 9', '2\n\n2 3\n0 8\n17 4\n\n4 0\n16 7\n15 11\n11 4\n19 3', '2\n\n2 2\n6 1\n12 20\n\n2 10\n19 8\n19 1', '1\n\n3 4\n0 19\n3 17\n9 13', '2\n\n4 9\n19 15\n0 18\n18 5\n19 7\n\n5 8\n1 12\n3 18\n19 11\n17 20\n14 0']
    for i in inputs:
        print(solution(i))