# TEST_RESULT: False
from itertools import permutations, product, combinations


def perfect_coloring_and_cut(matrix, colors, cut):
    left_matrix = matrix[:, :cut]
    right_matrix = matrix[:, cut:]
    red_indices = [i for (i, color) in enumerate(colors) if color == 'R']
    blue_indices = [i for (i, color) in enumerate(colors) if color == 'B']
    if len(red_indices) > 0 and len(blue_indices) > 0 and np.all(left_matrix[red_indices] > np.min(left_matrix[blue_indices])) and np.all(right_matrix[blue_indices] > np.min(right_matrix[red_indices])):
        return True
    return False

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    output = ''
    current_line = 1
    for _ in range(t):
        (n, m) = map(int, lines[current_line].split())
        current_line += 1
        matrix = np.array([list(map(int, lines[current_line + i].split())) for i in range(n)])
        current_line += n
        colors = [''.join(color) for color in product('RB', repeat=n) if 'R' in color and 'B' in color]
        cuts = list(range(1, m))
        for color in colors:
            for cut in cuts:
                for row_order in permutations(range(n)):
                    ordered_matrix = matrix[list(row_order)]
                    if perfect_coloring_and_cut(ordered_matrix, color, cut):
                        output += 'YES\n' + color + '\n' + str(cut) + '\n'
                        break
                else:
                    continue
                break
            else:
                continue
            break
        else:
            output += 'NO\n'
    return output.strip()
