import random


def gen_input(t: int) -> str:
    t = max(min(t, 200), 1)
    inputs = []
    for _ in range(t):
        n = random.randint(1, 100)
        sequence = [random.randint(1, 10 ** 9) for _ in range(n)]
        inputs.append(f"{n}\n{' '.join(map(str, sequence))}")
    return f'{t}\n' + '\n'.join(inputs)

def batch_gen_inputs(batch_size,) -> list:
    inputs = [gen_input(random.randint(1, 10)) for _ in range(batch_size)]
    return inputs
