import random
from sympy import primerange


import random
import sympy


import random
from sympy import isprime


import random


def gen_input(n_upper, m_upper):
    """Generates a single test input."""
    n = random.randint(1, n_upper)
    while True:
        m = random.randint(10 ** 8, min(10 ** 9, m_upper))
        if is_prime(m):
            break
    return f'{n} {m}\n'

def get_random_prime(lower, upper):
    primes = list(sympy.primerange(lower, upper))
    return random.choice(primes)

def generate_prime_number(lower, upper):
    prime = random.randint(lower, upper)
    while not isprime(prime):
        prime += 1
        if prime > upper:
            prime = lower
    return prime

def is_prime(n):
    """Checks if a number is prime."""
    if n <= 1:
        return False
    if n <= 3:
        return True
    if n % 2 == 0 or n % 3 == 0:
        return False
    i = 5
    while i * i <= n:
        if n % i == 0 or n % (i + 2) == 0:
            return False
        i += 6
    return True

def batch_gen_inputs(batch_size,):
    """Generates a batch of 5 test inputs."""
    inputs = [gen_input(25, 10 ** 9) for _ in range(batch_size)]
    return inputs
