# TEST_RESULT: True

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    (N, M) = map(int, lines[0].split())
    grid = [list(map(int, line.split())) for line in lines[1:]]
    directions = [8, 4, 2, 1]
    offsets = [(-1, 0), (0, 1), (1, 0), (0, -1)]
    visited = [[False] * M for _ in range(N)]
    room_sizes = []

    def dfs(i, j):
        """Performs a Depth-First Search from the tile at (i, j)."""
        if not (0 <= i < N and 0 <= j < M) or visited[i][j]:
            return 0
        visited[i][j] = True
        size = 1
        for (direction, offset) in zip(directions, offsets):
            if not grid[i][j] & direction:
                (ni, nj) = (i + offset[0], j + offset[1])
                size += dfs(ni, nj)
        return size
    for i in range(N):
        for j in range(M):
            if not visited[i][j]:
                room_sizes.append(dfs(i, j))
    room_sizes.sort(reverse=True)
    return ' '.join(map(str, room_sizes))
