import random


def gen_input(N: int, K: int) -> str:
    assert 3 <= N <= 2 * 10 ** 5
    assert 1 <= K <= N
    points = []
    for _ in range(N):
        x = random.randint(-10 ** 6, 10 ** 6)
        y = random.randint(-10 ** 6, 10 ** 6)
        points.append((x, y))
    input_data = []
    input_data.append(f'{N} {K}')
    for point in points:
        input_data.append(f'{point[0]} {point[1]}')
    return '\n'.join(input_data)

def batch_gen_inputs(batch_size,) -> list:
    inputs = []
    for _ in range(batch_size):
        N = random.randint(3, 10)
        K = random.randint(1, N)
        inputs.append(gen_input(N, K))
    return inputs
