import random

from typing import List

def gen_input(N: int, Q: int) -> str:
    cities = [random.randint(0, 10 ** 9 + 6) for _ in range(N)]
    queries = []
    for _ in range(Q):
        L = random.randint(1, N)
        R = random.randint(1, N)
        if L > R:
            (L, R) = (R, L)
        D = random.randint(0, 10 ** 9 + 6)
        queries.append((L, R, D))
    input_str = f'{N} {Q}\n'
    input_str += ' '.join(map(str, cities)) + '\n'
    for query in queries:
        input_str += ' '.join(map(str, query)) + '\n'
    return input_str

def batch_gen_inputs(batch_size,) -> List[str]:
    inputs = []
    for _ in range(batch_size):
        N = random.randint(1, 100)
        Q = random.randint(1, 100)
        inputs.append(gen_input(N, Q))
    return inputs
