import random


def gen_input(N_max=50, Q_max=50, A_max=100, x_max=100):
    N = random.randint(1, N_max)
    Q = random.randint(1, Q_max)
    A1 = [random.randint(0, A_max) for _ in range(N)]
    A2 = [random.randint(0, A_max) for _ in range(N)]
    queries = []
    for _ in range(Q):
        query_type = random.randint(1, 4)
        l = random.randint(1, N)
        r = random.randint(l, N)
        if query_type in {1, 2, 3}:
            k = random.randint(1, 2)
            if query_type == 3:
                x = random.randint(-x_max, x_max)
            else:
                x = random.randint(0, x_max)
            query = [query_type, k, l, r, x]
        else:
            query = [query_type, l, r]
        queries.append(query)
    input_str = f'{N} {Q}\n'
    input_str += ' '.join((str(x) for x in A1)) + '\n'
    input_str += ' '.join((str(x) for x in A2)) + '\n'
    for query in queries:
        input_str += ' '.join((str(x) for x in query)) + '\n'
    return input_str

def batch_gen_inputs(batch_size,):
    return [gen_input() for _ in range(batch_size)]
