import random
import itertools

def is_good(n):
    return '0' not in str(n)

def find_good_pair(nums):
    for i in range(len(nums) - 1):
        if is_good(nums[i] + nums[i + 1]):
            return (nums[i], nums[i + 1])
    return None

def gen_input(min_size=2, max_size=10, max_num=1000):
    nums = [n for n in range(1, max_num) if is_good(n)]
    nums = random.sample(nums, random.randint(min_size, max_size))
    good_pair = find_good_pair(nums)
    if not good_pair:
        return None
    s = ''.join((str(n) for n in nums))
    x = sum(good_pair)
    return f'{s}\n{x}'

def batch_gen_inputs(batch_size,):
    inputs = []
    for _ in range(batch_size):
        input_str = None
        while not input_str:
            input_str = gen_input()
        inputs.append(input_str)
    return inputs
