# TEST_RESULT: True

import itertools

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    n = int(lines[0])
    sequences = lines[1:]

    def is_rbs(seq):
        count = 0
        for char in seq:
            if char == '(':
                count += 1
            else:
                count -= 1
            if count < 0:
                return False
        return count == 0
    permutations = list(itertools.permutations(sequences))
    max_rbs_count = 0
    for permutation in permutations:
        concatenated_seq = ''.join(permutation)
        rbs_count = 0
        for i in range(1, len(concatenated_seq) + 1):
            if is_rbs(concatenated_seq[:i]):
                rbs_count += 1
        max_rbs_count = max(max_rbs_count, rbs_count)
    return str(max_rbs_count)
