import random
import string

from typing import List

def gen_input(t: int, max_n: int, max_sum_n: int) -> str:
    input_cases = []
    current_sum_n = 0
    for _ in range(t):
        n = random.randint(3, min(max_n, max_sum_n - current_sum_n))
        current_sum_n += n
        c = random.choice(string.ascii_lowercase)
        s = ''.join((random.choice(string.ascii_lowercase) for _ in range(n)))
        input_cases.append(f'{n} {c}\n{s}')
    return f'{t}\n' + '\n'.join(input_cases)

def batch_gen_inputs(batch_size,) -> List[str]:
    return [gen_input(t=5, max_n=10, max_sum_n=50) for _ in range(batch_size)]
