import random
from typing import List


def gen_input(n: int) -> str:
    p = list(range(1, n + 1))
    random.shuffle(p)
    input_str = str(n) + '\n'
    num_queries = n
    for _ in range(num_queries):
        a = [random.randint(1, n) for _ in range(n)]
        s = [pj + aj for (pj, aj) in zip(p, a)]
        k = next((i for (i, si) in enumerate(s, 1) if s.count(si) > 1), 0)
        input_str += '\n'.join((str(x) for x in a)) + '\n'
        input_str += str(k) + '\n'
    return input_str

def batch_gen_inputs(batch_size,) -> List[str]:
    inputs = []
    for _ in range(batch_size):
        n = random.randint(2, 10)
        inputs.append(gen_input(n))
    return inputs
