import random
import string


def gen_input(n_limit=10, m_limit=10, q_limit=5):
    n = random.randint(1, n_limit)
    m = random.randint(1, min(m_limit, int(1000000.0 / n)))
    grid = []
    for _ in range(n):
        row = ''.join((random.choice(['X', '.']) for _ in range(m)))
        grid.append(row)
    q = random.randint(1, q_limit)
    queries = []
    for _ in range(q):
        x1 = random.randint(1, m)
        x2 = random.randint(x1, m)
        queries.append(f'{x1} {x2}')
    input_str = f'{n} {m}\n' + '\n'.join(grid) + f'\n{q}\n' + '\n'.join(queries) + '\n'
    return input_str

def batch_gen_inputs(batch_size,):
    inputs = [gen_input() for _ in range(batch_size)]
    return inputs
