# TEST_RESULT: True


def solution(stdin: str) -> str:
    input_lines = stdin.strip().split('\n')
    (n, m) = map(int, input_lines[0].split())
    grid = input_lines[1:n + 1]
    q = int(input_lines[n + 1])
    queries = input_lines[n + 2:]
    grid = [list(row) for row in grid]

    def is_determinable(x1, x2):
        subgrid = [row[x1 - 1:x2] for row in grid]
        exitable = [[False for _ in range(x2 - x1 + 1)] for _ in range(n)]
        for i in range(n):
            for j in range(x2 - x1 + 1):
                if subgrid[i][j] == 'X':
                    continue
                if i == 0 or j == 0 or exitable[i - 1][j] or exitable[i][j - 1]:
                    exitable[i][j] = True
        reconstructed = [['X' for _ in range(x2 - x1 + 1)] for _ in range(n)]
        for i in range(n):
            for j in range(x2 - x1 + 1):
                if exitable[i][j] or (i > 0 and exitable[i - 1][j]) or (j > 0 and exitable[i][j - 1]):
                    reconstructed[i][j] = '.'
        return subgrid == reconstructed
    output = []
    for query in queries:
        (x1, x2) = map(int, query.split())
        if is_determinable(x1, x2):
            output.append('YES')
        else:
            output.append('NO')
    return '\n'.join(output)
