import random


def gen_input(n_max=100, m_max=50, t_max=5):
    assert 3 <= n_max <= 10 ** 5
    assert 1 <= m_max < n_max
    assert 1 <= t_max <= 10 ** 4
    t = random.randint(1, t_max)
    input_str = f'{t}\n'
    for _ in range(t):
        n = random.randint(3, n_max)
        m = random.randint(1, min(n - 1, m_max))
        input_str += f'{n} {m}\n'
        for _ in range(m):
            nodes = random.sample(range(1, n + 1), 3)
            input_str += f'{nodes[0]} {nodes[1]} {nodes[2]}\n'
    return input_str

def batch_gen_inputs(batch_size,):
    return [gen_input() for _ in range(batch_size)]
