# TEST_RESULT: True
from typing import List

def count_nearly_full_subsequences(index: int, current_sum: int, total_sum: int, arr: List[int]) -> int:
    if index >= len(arr):
        return 1 if current_sum == total_sum - 1 else 0
    count_included = count_nearly_full_subsequences(index + 1, current_sum + arr[index], total_sum, arr)
    count_excluded = count_nearly_full_subsequences(index + 1, current_sum, total_sum, arr)
    return count_included + count_excluded

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    output = []
    for i in range(t):
        n = int(lines[2 * i + 1])
        arr = list(map(int, lines[2 * i + 2].split()))
        total_sum = sum(arr)
        count = count_nearly_full_subsequences(0, 0, total_sum, arr)
        output.append(str(count))
    return '\n'.join(output)
