import random


def is_prime(n):
    """Check if a number is prime."""
    if n <= 1:
        return False
    if n <= 3:
        return True
    if n % 2 == 0 or n % 3 == 0:
        return False
    i = 5
    while i * i <= n:
        if n % i == 0 or n % (i + 2) == 0:
            return False
        i += 6
    return True

def get_random_prime_or_one(upper_limit):
    """Generate a random prime number up to upper_limit or 1."""
    primes = [i for i in range(2, upper_limit + 1) if is_prime(i)]
    primes.append(1)
    return random.choice(primes)

def gen_input(n_limit, m_limit, k_limit, a_limit):
    """Generate a random test input following the problem constraints."""
    n = random.randint(1, n_limit)
    m = random.randint(1, m_limit)
    k = get_random_prime_or_one(k_limit)
    a = ' '.join((str(random.randint(0, a_limit)) for _ in range(n)))
    return f'{n} {m} {k}\n{a}\n'

def batch_gen_inputs(batch_size,):
    """Generate a batch of test inputs."""
    return [gen_input(10, 10, 10, 10) for _ in range(batch_size)]
