import random
import string

def gen_input(n_max: int, m_max: int) -> str:
    n = random.randint(1, n_max)
    m = random.randint(1, min(m_max, 10 ** 6 // n))
    book_titles = set()
    while len(book_titles) < n:
        book_title = ''.join((random.choice(string.ascii_uppercase) for _ in range(m)))
        book_titles.add(book_title)
    input_string = f'{n} {m}\n' + '\n'.join(book_titles)
    return input_string

def batch_gen_inputs(batch_size,) -> list:
    inputs = []
    for _ in range(batch_size):
        inputs.append(gen_input(5, 10))
    return inputs
