from absl import app, flags
import csv
import os
import numpy as np
from scipy.stats import sem
import matplotlib.pyplot as plt

plt.rcParams.update({'font.size': 16})
FLAGS = flags.FLAGS

flags.DEFINE_string('filename', None, 'Input file name.')
flags.DEFINE_string('save_loc', None, 'save directory')
flags.mark_flag_as_required('filename')

def main(_):
	entropy = {}
	variance = {}
	with open(FLAGS.filename) as f:
		reader = csv.reader(f, delimiter='\t')
		for row in reader:
			if row[0] == 'num_suits':
				continue
			bias = float(row[4])
			H = float(row[5])
			var = float(row[6])
			if bias not in entropy.keys():
				entropy[bias] = []
				variance[bias] = []
			entropy[bias].append(H)
			variance[bias].append(var)

		for bias in entropy.keys():
			print(f'policy bias: {bias}\tentropy: {np.mean(entropy[bias]):10.3f}+/-{sem(entropy[bias]):0.3f} \tvariance: {np.mean(variance[bias]):10.3f}+/-{sem(variance[bias]):0.3f}')


if __name__ == "__main__":
	app.run(main)