# What Makes Data Suitable for a Locally Connected Neural Network? A Necessary and Sufficient Condition Based on Quantum Entanglement


Code implementation for the algorithms introduced in What Makes Data Suitable for a Locally Connected Neural Network? A Necessary and Sufficient Condition Based on Quantum Entanglement.

## Table of Contents

- [Configuration](#configuration)
- [Usage](#usage)

## Configuration

This project uses YAML configuration files to set various parameters for the experiments. You can find the configuration files in the `configs` folder.


### Parameters

Here is a list of common parameters and their explanations:

- `data_dir_name`: The name of the directory containing the dataset. The directory should be located in the `user_datasets` folder. See for example the `cifar10` folder. 
- `restructure_method`: The restructuring method used in the experiment (e.g., `feature_rearrangement_algorithm`, `igtd`).
- `device`: The device ID to be used for computation (0 for the first GPU, -1 for CPU, etc.).
- `data_name`: The name of the array containing the data.
- `labels_name`: The name of the array containing the labels.

#### Feature Rearrangement algorithm Parameters

- `cut_method`: The graph partitioning method used (e.g., `metis`).
- `niter_metis`: Number of iterations for the METIS algorithm.
- `ncuts_metis`: Number of cuts for the METIS algorithm.
- `metis_recursive`: Boolean value specifying whether to use recursive METIS partitioning.
- `seed_metis`: Seed value for the METIS algorithm.
- `num_parts`: Number of parts in each partition.

#### IGTD Parameters

- `no_imp_counter`: Initial value for the counter of iterations with no improvement.
- `no_imp_count_threshold`: Threshold for the number of iterations without improvement.
- `no_imp_val_threshold`: Threshold for the value of improvement.
- `t`: Maximal of iterations.


#### Entropy Measurement Parameters

- `levels`: The levels at which the entropy is to be measured.
- `entropy`: The entropy measurement method used (e.g., `entanglement entropy`, `geometric entropy`, `surrogate entropy`).
- `theta`: The angle of embedding for the entanglement entropy measurements (specified as a fraction of pi).
- `n_batches`: The number of batches to be used for the entropy measurements (batches are averaged to get any single measurement)
- `bath_size`: The size of each batch to be used for the entropy measurements.
- `fb_size`: The size of the feature batch to be used for the entropy measurements (can affect the efficiency of the measurements; should be set lower than the number of features in the data). 
- `vidal_noise`: A small amount of noise added to stabilize the SVD (used for the surrogate entropy measurements). 
## Usage

For restructuring the data, follow the example notebook `example_usage_data_restructuring.ipynb`.
For conducting entropy measurements, follow the example of the notebook `example_usage_entropy_measurement.ipynb`.

## Installation Instructions
Tested with python 3.9.7.
- Install PyTorch from the [official website](https://pytorch.org/) (tested with version 1.13.0) including `torchvision`.
- The requirements.txt file includes additional requirements, which can be installed via:
- `pip install -r requirements.txt`
- Install NetworkX-METIS from the official [GitHub repository](https://github.com/networkx/networkx-metis).