#!/bin/bash

# Constructing the path to the CSV file
csv_file="../CNN/utils/fNIRS_exp_combinations.csv"

# Checking if the CSV file exists
if [ ! -f "$csv_file" ]; then
    echo "Error: The CSV file does not exist at $csv_file"
    exit 1
fi

# Reading the CSV file and skipping the header
tail -n +2 "$csv_file" | while IFS=',' read -r offset window_size
do
    echo "python3 NIRS_affective_individual_task_CNN.py --p <path_to_fnirs_dataset_directory> --offset $offset --window_size $window_size --num_epochs 500"
done | xargs -I CMD -P 4 bash -c CMD
