from .functions.binarize_bnn2 import reswish_binarize2
from .qlinear import QLinear


class BinLinear2(QLinear):
    """
        Binary Linear module.
    """
    def __init__(self, *args, beta, **kwargs):
        """
        :param list args: args for :class:`antgine.modules.quantization.qlinear.QLinear`.
        :param float beta: beta assigned to Reswish.
        :param dict[str, any] kwargs: kwargs for :class:`antgine.modules.quantization.qlinear.QLinear`.
        """
        super().__init__(*args, qfunc=lambda x: reswish_binarize2(x, beta), **kwargs)
