# Batch Bayesian Optimization For Replicable Experimental Design (NeurIPS 2023)

This repository contains the implementation of the BTS-RED-Known, BTS-RED-Unknown and Mean-Var-BTS-RED algorithms in our paper, for the synthetic experiments (Section 5.1).

## Requirement:
- GPy (https://github.com/SheffieldML/GPy), as well as other commonly used packages including numpy and scipy

## Scripts:
- synth_bts_red.py: runs the BTS-RED-Known algorithm.
- synth_bts_red_unknown.py: runs the BTS-RED-Unknown algorithm.
- synth_bts_red_mean_var.py: runs the Mean-Var-BTS-RED algorithm.
- bayesian_optimization_bts_red.py: implementation of the BTS-RED-Known algorithm
- helper_funcs_bts_red.py: some helper functions for optimizing the acquisition function of the BTS-RED-Known algorithm
- bayesian_optimization_bts_red_mean_var.py: implementation of the BTS-RED-Unknown and Mean-Var-BTS-RED algorithms
- helper_funcs_bts_red.py_mean_var: some helper functions for optimizing the acquisition functions of the BTS-RED-Unknown and Mean-Var-BTS-RED algorithms
- analyze_results.ipynb: analyze and plot the results, i.e., Fig 1 c and d in the main paper.
