#/bin/bash
# Fixed

# exps=(fixed_ts_factor)
exps=(fixed_ts_bvae fixed_ts_svae fixed_ts_pcl)
seeds=(0 1 2022)

# Function to run a single experiment
run_experiment() {
    local exp=$1
    local seed=$2
    python scripts/train_baselines.py --exp "$exp" --seed "$seed"
}

# Loop through each combination of beta and delta values
num_parallel=0
for exp in "${exps[@]}"; do
    for seed in "${seeds[@]}"; do
        run_experiment "$exp" "$seed" &

        # Increment the parallel counter
        num_parallel=$((num_parallel + 1))
        # If two experiments are running, wait for them to finish
        if [ "$num_parallel" -eq 3 ]; then
            wait
            num_parallel=0
        fi
    done
done

# Wait for any remaining background jobs to finish
wait