# MEX-MB

Code of ``MEX-MB (Maximize to Explore-Model-Based)`` for the paper "One Objective to Rule Them All: A Maximization Objective Fusing Estimation and Planning for Exploration".

The code is adapted from the [``mbrl-lib``](https://github.com/facebookresearch/mbrl-lib/tree/main/mbrl) repo, which is a toolbox for facilitating development of 
Model-Based Reinforcement Learning algorithms. It provides easily interchangeable 
modeling and planning components, and a set of utility functions that allow writing
model-based RL algorithms with only a few lines of code. 


## Installation

### Standard Installation

``mbrl`` requires Python 3.8+ library and [PyTorch (>= 1.7)](https://pytorch.org). 
To install the latest stable version, run

    pip install mbrl

### Developer installation
If you are interested in modifying the library, clone the repository and set up 
a development environment as follows

    git clone https://github.com/facebookresearch/mbrl-lib.git
    pip install -e ".[dev]"

And test it by running the following from the root folder of the repository

    python -m pytest tests/core
    python -m pytest tests/algorithms

## Sparse Environments

The sparse environments are implemented in the ``./mujoco`` folder, which can replace the original ``gym/envs/mujoco`` folder to enable training in the sparse-reward tasks.

## Basic example

After installation, the following example can be run to train MEX-MB in the Ant-v2 environment.

    python ./mbrl/examples/main.py algorithm=mbpo overrides=mbpo_ant comment=mbpo device=cuda:0 seed=0

The ``overrides`` can be changed to the ones in the ``./mbrl/examples/conf/overrides`` folder to train other algorithms.
