from . import EntryUpdater

from typing import Union, Optional


class BinaryPathUpdater(EntryUpdater[str]):

    def insert(self, entry: str, pos: int, value: bytes) -> Optional[str]:    
        if value:
            # Since binary has changed, path is no longer valid
            return None
        
        return entry

    def delete(self, entry: str, pos: Union[int, range]) -> Optional[str]:
        pos = self._normalize_pos(pos)
        
        if pos.stop > pos.start:
            # Since binary has changed, path is no longer valid
            return None
        
        return entry

    def replace(self, entry: str, pos: Union[int, range], value: bytes) -> Optional[str]:
        pos = self._normalize_pos(pos)
        
        pos_len = pos.stop - pos.start
        if len(value) != pos_len:
            raise ValueError(f"`pos` to replace covers {pos_len} bytes, but `value` contains {len(value)} bytes")
        
        if pos.stop > pos.start:
            # Since binary has changed, path is no longer valid
            return None
        
        return entry

    def mask(self, entry: str, pos: Union[int, range]) -> Optional[str]:
        pos = self._normalize_pos(pos)
        
        if pos.stop > pos.start:
            # Since binary has been masked, path is no longer valid
            return None
        
        return entry