from .malware import MalwareFolder
from .utils import BinaryLoader

from typing import Callable, Optional, Tuple


class RawPE(MalwareFolder):
    def __init__(
        self,
        root: str,
        extensions: Optional[Tuple[str, ...]] = None,
        transform: Optional[Callable] = None, 
        target_transform: Optional[Callable] = None, 
        transforms: Optional[Callable] = None,
        is_valid_file: Optional[Callable[[str], bool]] = None,
    ) -> None:
        if extensions is None and is_valid_file is None:
            extensions = (".exe", ".dll")
        super().__init__(
            root,
            BinaryLoader(),
            extensions=extensions,
            transform=transform,
            target_transform=target_transform,
            transforms=transforms,
            is_valid_file=is_valid_file,
        )

